/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_2195;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;

public class DestroyPumpkin
extends class_4097<PumpkinWarden> {
    private class_2338 targetBlock;
    private class_2248 fruitBlock;
    protected int tryTicks;

    public DestroyPumpkin() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457, (Object)class_4140.field_18446, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(@NotNull class_3218 level, @NotNull PumpkinWarden pumpkinWarden) {
        return pumpkinWarden.canMove() && pumpkinWarden.method_5998(class_1268.field_5808).method_7960();
    }

    protected void tick(@NotNull class_3218 level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        if (this.targetBlock == null) {
            return;
        }
        if (!this.targetBlock.method_19769((class_2374)pumpkinWarden.method_73189(), 1.0)) {
            ++this.tryTicks;
            if (this.tryTicks > 200) {
                this.stop(level, pumpkinWarden, gameTime);
            }
        } else if (level.method_8320(this.targetBlock).method_27852(this.fruitBlock)) {
            class_2680 blockState = level.method_8320(this.targetBlock);
            level.method_8651(this.targetBlock, false, (class_1297)pumpkinWarden);
            level.method_43276((class_6880)class_5712.field_28165, this.targetBlock, class_5712.class_7397.method_43286((class_1297)pumpkinWarden, (class_2680)blockState));
            pumpkinWarden.method_6122(class_1268.field_5808, blockState.method_26204().method_8389().method_7854());
            this.stop(level, pumpkinWarden, gameTime);
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    protected boolean canStillUse(@NotNull class_3218 level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        return this.checkExtraStartConditions(level, pumpkinWarden);
    }

    protected void start(@NotNull class_3218 level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        Optional<class_2338> optionalBlockPos = this.findNearestBlock(level, pumpkinWarden.method_24515(), blockState -> blockState.method_26204() instanceof class_2195, 15.0);
        if (optionalBlockPos.isPresent()) {
            this.targetBlock = optionalBlockPos.get().method_10093((class_2350)level.method_8320(optionalBlockPos.get()).method_11654((class_2769)class_2195.field_9873));
            this.fruitBlock = level.method_8320(this.targetBlock).method_26204();
            pumpkinWarden.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142((class_4115)new class_4099(this.targetBlock), 0.8f, 1));
            pumpkinWarden.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.targetBlock));
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    private Optional<class_2338> findNearestBlock(@NotNull class_3218 level, class_2338 blockPos, Predicate<class_2680> predicate, double distance) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int i = 0;
        while ((double)i <= distance) {
            int j = 0;
            while ((double)j < distance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        mutableBlockPos.method_25504((class_2382)blockPos, k, i - 1, l);
                        if (blockPos.method_19771((class_2382)mutableBlockPos, distance) && predicate.test(level.method_8320((class_2338)mutableBlockPos))) {
                            return Optional.of(mutableBlockPos.method_10062());
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return Optional.empty();
    }

    protected void stop(@NotNull class_3218 level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        pumpkinWarden.method_18868().method_18875(class_4140.field_18446);
        pumpkinWarden.method_18868().method_18875(class_4140.field_18445);
    }
}

